import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/infrastructure/services/time_service.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/domain/models/data/comments_data.dart';
import 'package:admin_desktop/infrastructure/services/tr_keys.dart';

class ShowCommentModal extends StatelessWidget {
  final CommentsData comment;

  const ShowCommentModal({super.key, required this.comment});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.all(12),
      width: 600,
      decoration: BoxDecoration(
        color: Style.white,
        borderRadius: BorderRadius.circular(AppConstants.radius),
      ),
      child: SingleChildScrollView(
        child: Padding(
          padding: const EdgeInsets.all(16),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.end,
            children: [
              Row(
                children: [
                  Text(
                        AppHelpers.getTranslation(TrKeys.productReview),
                    style: Style.interNormal(),
                  ),
                  Spacer(),
                  GestureDetector(
                      onTap: () {
                        Navigator.pop(context);
                      },
                      child: Icon(Icons.clear))
                ],
              ),
              16.verticalSpace,
              Table(
                defaultVerticalAlignment: TableCellVerticalAlignment.middle,
                border: TableBorder.all(
                  color: Style.greyColor,
                  width: 1.5,
                  borderRadius: BorderRadius.circular(AppConstants.radius),
                ),
                columnWidths: const {
                  0: FlexColumnWidth(1),
                  1: FlexColumnWidth(2),
                },
                children: [
                  TableRow(
                    children: [
                      Padding(
                        padding: const EdgeInsets.all(12),
                        child: Text(AppHelpers.getTranslation(TrKeys.id)),
                      ),
                      Padding(
                        padding: const EdgeInsets.all(12),
                        child: Text('${comment.id ?? 0}'),
                      ),
                    ],
                  ),
                  TableRow(
                    children: [
                      Padding(
                        padding: const EdgeInsets.all(12),
                        child: Text(AppHelpers.getTranslation(TrKeys.user)),
                      ),
                      Padding(
                        padding: const EdgeInsets.all(12),
                        child: Text(
                            '${comment.user?.firstname ?? "  -"} ${comment.user?.lastname ?? ""}'),
                      ),
                    ],
                  ),
                  TableRow(
                    children: [
                      Padding(
                        padding: const EdgeInsets.all(12),
                        child: Text(AppHelpers.getTranslation(TrKeys.rating)),
                      ),
                      Padding(
                        padding: const EdgeInsets.all(12),
                        child: Row(
                          children: [
                            Text('${comment.rating ?? 0}'),
                            4.horizontalSpace,
                            Icon(
                              Icons.star,
                              color: Style.yellow,
                              size: 20,
                            )
                          ],
                        ),
                      ),
                    ],
                  ),
                  if (comment.img != null)
                    TableRow(
                      children: [
                        Padding(
                          padding: const EdgeInsets.all(12),
                          child: Text(AppHelpers.getTranslation(TrKeys.image)),
                        ),
                        Padding(
                          padding: const EdgeInsets.only(
                              right: 200, left: 16, top: 12, bottom: 12),
                          child: CommonImage(
                            url: comment.img,
                            width: 100,
                            height: 150,
                          ),
                        ),
                      ],
                    ),
                  if (comment.product?.id != null)
                    TableRow(
                      children: [
                        Padding(
                          padding: const EdgeInsets.all(12),
                          child:
                              Text(AppHelpers.getTranslation(TrKeys.productId)),
                        ),
                        Padding(
                          padding: const EdgeInsets.all(12),
                          child: Text("${comment.product?.id ?? 0}"),
                        ),
                      ],
                    ),
                  TableRow(
                    children: [
                      Padding(
                        padding: const EdgeInsets.all(12),
                        child: Text(AppHelpers.getTranslation(TrKeys.comment)),
                      ),
                      Padding(
                        padding: const EdgeInsets.all(12),
                        child: Text(comment.comment ?? ""),
                      ),
                    ],
                  ),
                  TableRow(
                    children: [
                      Padding(
                        padding: const EdgeInsets.all(12),
                        child:
                            Text(AppHelpers.getTranslation(TrKeys.createdDate)),
                      ),
                      Padding(
                        padding: const EdgeInsets.all(12),
                        child: Text(
                            TimeService.dateFormatMDYHm(comment.createdAt)),
                      ),
                    ],
                  ),
                ],
              ),
              16.verticalSpace,
            ],
          ),
        ),
      ),
    );
  }
}
